
# Edit Work Week
# Copyright 2004 by Alexander V. Christensen
#   Special thanks to Brian Christensen

"""
Modify the default working hours, by day of the week,
  for all projects in the current file.
"""

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 040716 - first version, based on an example script by Brian Christensen
# 040720 - cleaned up the label and TextCtrl definitions; added OnFocus to
#   simplify entry from the keyboard

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

# define a dialog to input the new work week
class WorkWeekDialog(wx.Dialog):
    def __init__(self, parent):
        wx.Dialog.__init__(self, parent, -1, 'Edit Work Week')
        border_sizer = wx.BoxSizer(wx.VERTICAL)

        sizer = wx.BoxSizer(wx.VERTICAL)
        label = wx.StaticText(self, -1, 'New work hours:')
        sizer.Add(label)
        sizer.Add((20, 20))

        daysofweek = wx.BoxSizer(wx.HORIZONTAL)
        for day in ['M', 'T', 'W', 'H', 'F', 'S', 'S']:
             label = wx.StaticText(self, -1, day, style=wx.ALIGN_CENTRE)
             daysofweek.Add(label, 1, wx.GROW | wx.LEFT | wx.RIGHT | wx.ALIGN_CENTRE, 5)
        sizer.Add(daysofweek, 1, wx.GROW | wx.ALIGN_CENTRE)
        sizer.Add((5, 5))

        workhours = wx.BoxSizer(wx.HORIZONTAL)
        self.controls = []
        for day in Data.Database['OtherData'][1]['WeekHours']:
             hourCtrl = wx.TextCtrl(self, -1, str(day), size=(30, 25))
             workhours.Add(hourCtrl, 0, wx.LEFT | wx.RIGHT | wx.ALIGN_CENTRE, 5)
             self.controls.append(hourCtrl)
	     hourCtrl.Bind(wx.EVT_SET_FOCUS, self.OnFocus)
        sizer.Add(workhours, 0, wx.ALIGN_CENTRE)
        sizer.Add((25, 25))

        buttons = wx.BoxSizer(wx.HORIZONTAL)
    
        cancelbutton = wx.Button(self, wx.ID_CANCEL, "Cancel", size=(70, 20))
        buttons.Add(cancelbutton, 0, wx.RIGHT, 5)

        okbutton = wx.Button(self, wx.ID_OK, "OK", size=(70, 20))
        okbutton.SetDefault()
        buttons.Add(okbutton, 0, wx.LEFT, 5)

        sizer.Add(buttons, 0, wx.ALIGN_RIGHT)
        sizer.Add((5, 5))

        border_sizer.Add(sizer, 0, wx.ALL | wx.ALIGN_CENTRE, 10)
        self.SetSizer(border_sizer)
        self.Fit()
        self.CentreOnScreen()

    def OnFocus(self, evt):
        source = evt.GetEventObject()
        if source in self.controls:
             source.SetSelection(-1, -1)
        evt.Skip()
        self.Refresh()

    def ReadValues(self):
        values = []
        for ctrl in self.controls:
            try:
                val = int(ctrl.GetValue())
                if val < 0: val = 0
            except ValueError:
                val = 0
            values.append(val)
        return tuple(values)

def EditWorkWeek():
    dlg = WorkWeekDialog(None)
    if dlg.ShowModal() != wx.ID_OK:
        return
    workweek = dlg.ReadValues()
    if sum(workweek) <= 0:
        hint("Empty or invalid work week.")
        return
    change = {'Table': 'OtherData', 'ID': 1, 'WeekHours': workweek}
    Data.Update(change)
    Data.SetUndo('Edit Work Week')

EditWorkWeek()
